scriptname _SLSubmitSurrenderSelectEffect extends ActiveMagicEffect  

; This is a modified SexLab MatchMaker script

_SLSubmitConfig Property _SLConfig auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene Auto
SexLabFramework property SexLab auto

Keyword Property ActorTypeNPC  Auto  
SPELL Property _SLSubmitAssign  Auto  
SPELL Property _SLSubmitCalm  Auto  
ReferenceAlias property ActorFollowerTemp auto
GlobalVariable Property _SLSubmitFSurrenderGlobal  Auto
MagicEffect Property CalmEffect Auto
Actor Property PlayerRef Auto
Faction Property _SLSubmitSatedFaction Auto
Package Property BullyPackage Auto

event OnEffectStart(actor Target, actor Caster)
	If (Target.IsPlayerTeammate())
		Target.StopCombat()
		If (ActorFollowerTemp.GetActorRef() != Target)
			ActorFollowerTemp.ForceRefTo(Target)
			Target.StopCombat()
		EndIf
		Target.StopCombat()
	ElseIf (Target != None && PlayerRef != None)
		If (Target.Is3DLoaded() && (IsHostile(Target) || IsInMood(Target)) && !Target.IsDead() && !Target.IsPlayerTeammate())
			_SLSubmitCalm.Cast(Target)
			Target.StopCombat()
			_SLScene.WRT(0.1)
			If ((Target.GetDistance(PlayerRef) <= _SLConfig.Range || (Target.GetDistance(PlayerRef) <= 250 && Target.HasLOS(PlayerRef))) && IsValidTarget(Target))
				_SLSubmitAssign.Cast(Target)
			EndIf
			If (IsInMood(Target))
				ActorUtil.AddPackageOverride(Target, BullyPackage, 100)
				; Remember the fact that we added BullyPackage to Target so we can remove it later
				int value = StorageUtil.FormListFind(BullyPackage, "_SLSubmitBullyActorList", Target)
				;debug.notification("FormListFind returned " + value)
				If (value == -1)
					;debug.notification("Adding "+Target.GetActorBase().GetName())
					StorageUtil.FormListAdd(BullyPackage, "_SLSubmitBullyActorList", Target)
				EndIf
			EndIf
		EndIf
	EndIf
endEvent

bool Function IsHostile(actor Target)
	If (Target.IsInCombat() && Target.IsHostileToActor(PlayerRef))
		return True
	Else
		return False
	EndIf
EndFunction

bool Function IsInMood(actor Target)
	If (Target.HasMagicEffect(CalmEffect) && !Target.IsInFaction(_SLSubmitSatedFaction))
		return True
	Else
		return False
	EndIf
EndFunction

bool Function IsValidTarget(actor Target)
	If ((_SLConfig.Creature >= 0 && Target.HasKeyword(ActorTypeNPC)) || (_SLConfig.Creature >= 1 && _SLQuest.SentientNPC(Target)) || (_SLConfig.Creature >= 2 && _SLQuest.NonSentientNPC(Target)))
		return True
	Else
		return False
	EndIf
EndFunction